@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A node pool snapshot resource.
 * @property creationData CreationData to be used to specify the source agent pool resource ID to create this snapshot.
 * @property enableFIPS Whether to use a FIPS-enabled OS.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property kubernetesVersion The version of Kubernetes.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property nodeImageVersion The version of node image.
 * @property osSku Specifies the OS SKU used by the agent pool. The default is Ubuntu if OSType is Linux. The default is Windows2019 when Kubernetes <= 1.24 or Windows2022 when Kubernetes >= 1.25 if OSType is Windows.
 * @property osType The operating system type. The default is Linux.
 * @property snapshotType The type of a snapshot. The default is NodePool.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property vmSize The size of the VM.
 */
public data class GetSnapshotResult(
    public val creationData: CreationDataResponse? = null,
    public val enableFIPS: Boolean,
    public val id: String,
    public val kubernetesVersion: String,
    public val location: String,
    public val name: String,
    public val nodeImageVersion: String,
    public val osSku: String,
    public val osType: String,
    public val snapshotType: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val vmSize: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.GetSnapshotResult): GetSnapshotResult = GetSnapshotResult(
            creationData = javaType.creationData().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.CreationDataResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            enableFIPS = javaType.enableFIPS(),
            id = javaType.id(),
            kubernetesVersion = javaType.kubernetesVersion(),
            location = javaType.location(),
            name = javaType.name(),
            nodeImageVersion = javaType.nodeImageVersion(),
            osSku = javaType.osSku(),
            osType = javaType.osType(),
            snapshotType = javaType.snapshotType().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.containerservice.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            vmSize = javaType.vmSize(),
        )
    }
}
