@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A label selector requirement is a selector that contains values, a key, and an operator that relates the key and values.
 * @property key key is the label key that the selector applies to.
 * @property operator operator represents a key's relationship to a set of values. Valid operators are In and NotIn
 * @property values values is an array of string values, the values array must be non-empty.
 */
public data class LabelSelectorRequirementResponse(
    public val key: String? = null,
    public val `operator`: String? = null,
    public val values: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.LabelSelectorRequirementResponse): LabelSelectorRequirementResponse = LabelSelectorRequirementResponse(
            key = javaType.key().map({ args0 -> args0 }).orElse(null),
            `operator` = javaType.`operator`().map({ args0 -> args0 }).orElse(null),
            values = javaType.values().map({ args0 -> args0 }),
        )
    }
}
