@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A label selector is a label query over a set of resources. The result of matchLabels and matchExpressions are ANDed. An empty label selector matches all objects. A null label selector matches no objects.
 * @property matchExpressions matchExpressions is a list of label selector requirements. The requirements are ANDed.
 * @property matchLabels matchLabels is an array of {key=value} pairs. A single {key=value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is `key`, the operator is `In`, and the values array contains only `value`. The requirements are ANDed.
 */
public data class LabelSelectorResponse(
    public val matchExpressions: List<LabelSelectorRequirementResponse>? = null,
    public val matchLabels: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.LabelSelectorResponse): LabelSelectorResponse = LabelSelectorResponse(
            matchExpressions = javaType.matchExpressions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.LabelSelectorRequirementResponse.Companion.toKotlin(args0)
                })
            }),
            matchLabels = javaType.matchLabels().map({ args0 -> args0 }),
        )
    }
}
