@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Managed cluster Access Profile.
 * @property id Resource Id
 * @property kubeConfig Base64-encoded Kubernetes configuration file.
 * @property location Resource location
 * @property name Resource name
 * @property tags Resource tags
 * @property type Resource type
 */
public data class ListManagedClusterAccessProfileResult(
    public val id: String,
    public val kubeConfig: String? = null,
    public val location: String,
    public val name: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.ListManagedClusterAccessProfileResult): ListManagedClusterAccessProfileResult = ListManagedClusterAccessProfileResult(
            id = javaType.id(),
            kubeConfig = javaType.kubeConfig().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
