@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Access profile for managed cluster API server.
 * @property authorizedIPRanges IP ranges are specified in CIDR format, e.g. 137.117.106.88/29. This feature is not compatible with clusters that use Public IP Per Node, or clusters that are using a Basic Load Balancer. For more information see [API server authorized IP ranges](https://docs.microsoft.com/azure/aks/api-server-authorized-ip-ranges).
 * @property disableRunCommand Whether to disable run command for the cluster or not.
 * @property enablePrivateCluster For more details, see [Creating a private AKS cluster](https://docs.microsoft.com/azure/aks/private-clusters).
 * @property enablePrivateClusterPublicFQDN Whether to create additional public FQDN for private cluster or not.
 * @property privateDNSZone The default is System. For more details see [configure private DNS zone](https://docs.microsoft.com/azure/aks/private-clusters#configure-private-dns-zone). Allowed values are 'system' and 'none'.
 */
public data class ManagedClusterAPIServerAccessProfileResponse(
    public val authorizedIPRanges: List<String>? = null,
    public val disableRunCommand: Boolean? = null,
    public val enablePrivateCluster: Boolean? = null,
    public val enablePrivateClusterPublicFQDN: Boolean? = null,
    public val privateDNSZone: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.ManagedClusterAPIServerAccessProfileResponse): ManagedClusterAPIServerAccessProfileResponse = ManagedClusterAPIServerAccessProfileResponse(
            authorizedIPRanges = javaType.authorizedIPRanges().map({ args0 -> args0 }),
            disableRunCommand = javaType.disableRunCommand().map({ args0 -> args0 }).orElse(null),
            enablePrivateCluster = javaType.enablePrivateCluster().map({ args0 -> args0 }).orElse(null),
            enablePrivateClusterPublicFQDN = javaType.enablePrivateClusterPublicFQDN().map({ args0 ->
                args0
            }).orElse(null),
            privateDNSZone = javaType.privateDNSZone().map({ args0 -> args0 }).orElse(null),
        )
    }
}
