@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A Kubernetes add-on profile for a managed cluster.
 * @property config Key-value pairs for configuring an add-on.
 * @property enabled Whether the add-on is enabled or not.
 * @property identity Information of user assigned identity used by this add-on.
 */
public data class ManagedClusterAddonProfileResponse(
    public val config: Map<String, String>? = null,
    public val enabled: Boolean,
    public val identity: ManagedClusterAddonProfileResponseIdentity,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.ManagedClusterAddonProfileResponse): ManagedClusterAddonProfileResponse = ManagedClusterAddonProfileResponse(
            config = javaType.config().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            enabled = javaType.enabled(),
            identity = javaType.identity().let({ args0 ->
                com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterAddonProfileResponseIdentity.Companion.toKotlin(args0)
            }),
        )
    }
}
