@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Information of user assigned identity used by this add-on.
 * @property clientId The client ID of the user assigned identity.
 * @property objectId The object ID of the user assigned identity.
 * @property resourceId The resource ID of the user assigned identity.
 */
public data class ManagedClusterAddonProfileResponseIdentity(
    public val clientId: String? = null,
    public val objectId: String? = null,
    public val resourceId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.ManagedClusterAddonProfileResponseIdentity): ManagedClusterAddonProfileResponseIdentity = ManagedClusterAddonProfileResponseIdentity(
            clientId = javaType.clientId().map({ args0 -> args0 }).orElse(null),
            objectId = javaType.objectId().map({ args0 -> args0 }).orElse(null),
            resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
