@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Profile for the container service agent pool.
 * @property availabilityZones The list of Availability zones to use for nodes. This can only be specified if the AgentPoolType property is 'VirtualMachineScaleSets'.
 * @property count Number of agents (VMs) to host docker containers. Allowed values must be in the range of 0 to 1000 (inclusive) for user pools and in the range of 1 to 1000 (inclusive) for system pools. The default value is 1.
 * @property creationData CreationData to be used to specify the source Snapshot ID if the node pool will be created/upgraded using a snapshot.
 * @property currentOrchestratorVersion If orchestratorVersion is a fully specified version <major.minor.patch>, this field will be exactly equal to it. If orchestratorVersion is <major.minor>, this field will contain the full <major.minor.patch> version being used.
 * @property enableAutoScaling Whether to enable auto-scaler
 * @property enableEncryptionAtHost This is only supported on certain VM sizes and in certain Azure regions. For more information, see: https://docs.microsoft.com/azure/aks/enable-host-encryption
 * @property enableFIPS See [Add a FIPS-enabled node pool](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#add-a-fips-enabled-node-pool-preview) for more details.
 * @property enableNodePublicIP Some scenarios may require nodes in a node pool to receive their own dedicated public IP addresses. A common scenario is for gaming workloads, where a console needs to make a direct connection to a cloud virtual machine to minimize hops. For more information see [assigning a public IP per node](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#assign-a-public-ip-per-node-for-your-node-pools). The default is false.
 * @property enableUltraSSD Whether to enable UltraSSD
 * @property gpuInstanceProfile GPUInstanceProfile to be used to specify GPU MIG instance profile for supported GPU VM SKU.
 * @property hostGroupID This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}. For more information see [Azure dedicated hosts](https://docs.microsoft.com/azure/virtual-machines/dedicated-hosts).
 * @property kubeletConfig The Kubelet configuration on the agent pool nodes.
 * @property kubeletDiskType Determines the placement of emptyDir volumes, container runtime data root, and Kubelet ephemeral storage.
 * @property linuxOSConfig The OS configuration of Linux agent nodes.
 * @property maxCount The maximum number of nodes for auto-scaling
 * @property maxPods The maximum number of pods that can run on a node.
 * @property minCount The minimum number of nodes for auto-scaling
 * @property mode A cluster must have at least one 'System' Agent Pool at all times. For additional information on agent pool restrictions and best practices, see: https://docs.microsoft.com/azure/aks/use-system-pools
 * @property name Windows agent pool names must be 6 characters or less.
 * @property nodeImageVersion The version of node image
 * @property nodeLabels The node labels to be persisted across all nodes in agent pool.
 * @property nodePublicIPPrefixID This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIPPrefixName}
 * @property nodeTaints The taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
 * @property orchestratorVersion Both patch version <major.minor.patch> (e.g. 1.20.13) and <major.minor> (e.g. 1.20) are supported. When <major.minor> is specified, the latest supported GA patch version is chosen automatically. Updating the cluster with the same <major.minor> once it has been created (e.g. 1.14.x -> 1.14) will not trigger an upgrade, even if a newer patch version is available. As a best practice, you should upgrade all node pools in an AKS cluster to the same Kubernetes version. The node pool version must have the same major version as the control plane. The node pool minor version must be within two minor versions of the control plane version. The node pool version cannot be greater than the control plane version. For more information see [upgrading a node pool](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#upgrade-a-node-pool).
 * @property osDiskSizeGB OS Disk Size in GB to be used to specify the disk size for every machine in the master/agent pool. If you specify 0, it will apply the default osDisk size according to the vmSize specified.
 * @property osDiskType The default is 'Ephemeral' if the VM supports it and has a cache disk larger than the requested OSDiskSizeGB. Otherwise, defaults to 'Managed'. May not be changed after creation. For more information see [Ephemeral OS](https://docs.microsoft.com/azure/aks/cluster-configuration#ephemeral-os).
 * @property osSKU Specifies the OS SKU used by the agent pool. The default is Ubuntu if OSType is Linux. The default is Windows2019 when Kubernetes <= 1.24 or Windows2022 when Kubernetes >= 1.25 if OSType is Windows.
 * @property osType The operating system type. The default is Linux.
 * @property podSubnetID If omitted, pod IPs are statically assigned on the node subnet (see vnetSubnetID for more details). This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}
 * @property powerState When an Agent Pool is first created it is initially Running. The Agent Pool can be stopped by setting this field to Stopped. A stopped Agent Pool stops all of its VMs and does not accrue billing charges. An Agent Pool can only be stopped if it is Running and provisioning state is Succeeded
 * @property provisioningState The current deployment or provisioning state.
 * @property proximityPlacementGroupID The ID for Proximity Placement Group.
 * @property scaleDownMode This also effects the cluster autoscaler behavior. If not specified, it defaults to Delete.
 * @property scaleSetEvictionPolicy This cannot be specified unless the scaleSetPriority is 'Spot'. If not specified, the default is 'Delete'.
 * @property scaleSetPriority The Virtual Machine Scale Set priority. If not specified, the default is 'Regular'.
 * @property spotMaxPrice Possible values are any decimal value greater than zero or -1 which indicates the willingness to pay any on-demand price. For more details on spot pricing, see [spot VMs pricing](https://docs.microsoft.com/azure/virtual-machines/spot-vms#pricing)
 * @property tags The tags to be persisted on the agent pool virtual machine scale set.
 * @property type The type of Agent Pool.
 * @property upgradeSettings Settings for upgrading the agentpool
 * @property vmSize VM size availability varies by region. If a node contains insufficient compute resources (memory, cpu, etc) pods might fail to run correctly. For more details on restricted VM sizes, see: https://docs.microsoft.com/azure/aks/quotas-skus-regions
 * @property vnetSubnetID If this is not specified, a VNET and subnet will be generated and used. If no podSubnetID is specified, this applies to nodes and pods, otherwise it applies to just nodes. This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}
 * @property workloadRuntime Determines the type of workload a node can run.
 */
public data class ManagedClusterAgentPoolProfileResponse(
    public val availabilityZones: List<String>? = null,
    public val count: Int? = null,
    public val creationData: CreationDataResponse? = null,
    public val currentOrchestratorVersion: String,
    public val enableAutoScaling: Boolean? = null,
    public val enableEncryptionAtHost: Boolean? = null,
    public val enableFIPS: Boolean? = null,
    public val enableNodePublicIP: Boolean? = null,
    public val enableUltraSSD: Boolean? = null,
    public val gpuInstanceProfile: String? = null,
    public val hostGroupID: String? = null,
    public val kubeletConfig: KubeletConfigResponse? = null,
    public val kubeletDiskType: String? = null,
    public val linuxOSConfig: LinuxOSConfigResponse? = null,
    public val maxCount: Int? = null,
    public val maxPods: Int? = null,
    public val minCount: Int? = null,
    public val mode: String? = null,
    public val name: String,
    public val nodeImageVersion: String,
    public val nodeLabels: Map<String, String>? = null,
    public val nodePublicIPPrefixID: String? = null,
    public val nodeTaints: List<String>? = null,
    public val orchestratorVersion: String? = null,
    public val osDiskSizeGB: Int? = null,
    public val osDiskType: String? = null,
    public val osSKU: String? = null,
    public val osType: String? = null,
    public val podSubnetID: String? = null,
    public val powerState: PowerStateResponse? = null,
    public val provisioningState: String,
    public val proximityPlacementGroupID: String? = null,
    public val scaleDownMode: String? = null,
    public val scaleSetEvictionPolicy: String? = null,
    public val scaleSetPriority: String? = null,
    public val spotMaxPrice: Double? = null,
    public val tags: Map<String, String>? = null,
    public val type: String? = null,
    public val upgradeSettings: AgentPoolUpgradeSettingsResponse? = null,
    public val vmSize: String? = null,
    public val vnetSubnetID: String? = null,
    public val workloadRuntime: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.ManagedClusterAgentPoolProfileResponse): ManagedClusterAgentPoolProfileResponse = ManagedClusterAgentPoolProfileResponse(
            availabilityZones = javaType.availabilityZones().map({ args0 -> args0 }),
            count = javaType.count().map({ args0 -> args0 }).orElse(null),
            creationData = javaType.creationData().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.CreationDataResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            currentOrchestratorVersion = javaType.currentOrchestratorVersion(),
            enableAutoScaling = javaType.enableAutoScaling().map({ args0 -> args0 }).orElse(null),
            enableEncryptionAtHost = javaType.enableEncryptionAtHost().map({ args0 -> args0 }).orElse(null),
            enableFIPS = javaType.enableFIPS().map({ args0 -> args0 }).orElse(null),
            enableNodePublicIP = javaType.enableNodePublicIP().map({ args0 -> args0 }).orElse(null),
            enableUltraSSD = javaType.enableUltraSSD().map({ args0 -> args0 }).orElse(null),
            gpuInstanceProfile = javaType.gpuInstanceProfile().map({ args0 -> args0 }).orElse(null),
            hostGroupID = javaType.hostGroupID().map({ args0 -> args0 }).orElse(null),
            kubeletConfig = javaType.kubeletConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.KubeletConfigResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            kubeletDiskType = javaType.kubeletDiskType().map({ args0 -> args0 }).orElse(null),
            linuxOSConfig = javaType.linuxOSConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.LinuxOSConfigResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            maxCount = javaType.maxCount().map({ args0 -> args0 }).orElse(null),
            maxPods = javaType.maxPods().map({ args0 -> args0 }).orElse(null),
            minCount = javaType.minCount().map({ args0 -> args0 }).orElse(null),
            mode = javaType.mode().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            nodeImageVersion = javaType.nodeImageVersion(),
            nodeLabels = javaType.nodeLabels().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            nodePublicIPPrefixID = javaType.nodePublicIPPrefixID().map({ args0 -> args0 }).orElse(null),
            nodeTaints = javaType.nodeTaints().map({ args0 -> args0 }),
            orchestratorVersion = javaType.orchestratorVersion().map({ args0 -> args0 }).orElse(null),
            osDiskSizeGB = javaType.osDiskSizeGB().map({ args0 -> args0 }).orElse(null),
            osDiskType = javaType.osDiskType().map({ args0 -> args0 }).orElse(null),
            osSKU = javaType.osSKU().map({ args0 -> args0 }).orElse(null),
            osType = javaType.osType().map({ args0 -> args0 }).orElse(null),
            podSubnetID = javaType.podSubnetID().map({ args0 -> args0 }).orElse(null),
            powerState = javaType.powerState().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.PowerStateResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            proximityPlacementGroupID = javaType.proximityPlacementGroupID().map({ args0 ->
                args0
            }).orElse(null),
            scaleDownMode = javaType.scaleDownMode().map({ args0 -> args0 }).orElse(null),
            scaleSetEvictionPolicy = javaType.scaleSetEvictionPolicy().map({ args0 -> args0 }).orElse(null),
            scaleSetPriority = javaType.scaleSetPriority().map({ args0 -> args0 }).orElse(null),
            spotMaxPrice = javaType.spotMaxPrice().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            upgradeSettings = javaType.upgradeSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.AgentPoolUpgradeSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            vmSize = javaType.vmSize().map({ args0 -> args0 }).orElse(null),
            vnetSubnetID = javaType.vnetSubnetID().map({ args0 -> args0 }).orElse(null),
            workloadRuntime = javaType.workloadRuntime().map({ args0 -> args0 }).orElse(null),
        )
    }
}
