@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Kube State Metrics profile for the Azure Managed Prometheus addon. These optional settings are for the kube-state-metrics pod that is deployed with the addon. See aka.ms/AzureManagedPrometheus-optional-parameters for details.
 * @property metricAnnotationsAllowList Comma-separated list of Kubernetes annotation keys that will be used in the resource's labels metric (Example: 'namespaces=[kubernetes&#46;io/team,&#46;&#46;&#46;],pods=[kubernetes&#46;io/team],...'). By default the metric contains only resource name and namespace labels.
 * @property metricLabelsAllowlist Comma-separated list of additional Kubernetes label keys that will be used in the resource's labels metric (Example: 'namespaces=[k8s-label-1,k8s-label-n,&#46;&#46;&#46;],pods=[app],...'). By default the metric contains only resource name and namespace labels.
 */
public data class ManagedClusterAzureMonitorProfileKubeStateMetricsResponse(
    public val metricAnnotationsAllowList: String? = null,
    public val metricLabelsAllowlist: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.ManagedClusterAzureMonitorProfileKubeStateMetricsResponse): ManagedClusterAzureMonitorProfileKubeStateMetricsResponse =
            ManagedClusterAzureMonitorProfileKubeStateMetricsResponse(
                metricAnnotationsAllowList = javaType.metricAnnotationsAllowList().map({ args0 ->
                    args0
                }).orElse(null),
                metricLabelsAllowlist = javaType.metricLabelsAllowlist().map({ args0 -> args0 }).orElse(null),
            )
    }
}
