@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Cluster HTTP proxy configuration.
 * @property httpProxy The HTTP proxy server endpoint to use.
 * @property httpsProxy The HTTPS proxy server endpoint to use.
 * @property noProxy The endpoints that should not go through proxy.
 * @property trustedCa Alternative CA cert to use for connecting to proxy servers.
 */
public data class ManagedClusterHTTPProxyConfigResponse(
    public val httpProxy: String? = null,
    public val httpsProxy: String? = null,
    public val noProxy: List<String>? = null,
    public val trustedCa: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.ManagedClusterHTTPProxyConfigResponse): ManagedClusterHTTPProxyConfigResponse = ManagedClusterHTTPProxyConfigResponse(
            httpProxy = javaType.httpProxy().map({ args0 -> args0 }).orElse(null),
            httpsProxy = javaType.httpsProxy().map({ args0 -> args0 }).orElse(null),
            noProxy = javaType.noProxy().map({ args0 -> args0 }),
            trustedCa = javaType.trustedCa().map({ args0 -> args0 }).orElse(null),
        )
    }
}
