@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Identity for the managed cluster.
 * @property principalId The principal id of the system assigned identity which is used by master components.
 * @property tenantId The tenant id of the system assigned identity which is used by master components.
 * @property type For more information see [use managed identities in AKS](https://docs.microsoft.com/azure/aks/use-managed-identity).
 * @property userAssignedIdentities The keys must be ARM resource IDs in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
 */
public data class ManagedClusterIdentityResponse(
    public val principalId: String,
    public val tenantId: String,
    public val type: String? = null,
    public val userAssignedIdentities: Map<String, ManagedClusterIdentityResponseUserAssignedIdentities>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.ManagedClusterIdentityResponse): ManagedClusterIdentityResponse = ManagedClusterIdentityResponse(
            principalId = javaType.principalId(),
            tenantId = javaType.tenantId(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            userAssignedIdentities = javaType.userAssignedIdentities().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterIdentityResponseUserAssignedIdentities.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
        )
    }
}
