@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * Desired managed outbound IPs for the cluster load balancer.
 * @property count The desired number of IPv4 outbound IPs created/managed by Azure for the cluster load balancer. Allowed values must be in the range of 1 to 100 (inclusive). The default value is 1.
 * @property countIPv6 The desired number of IPv6 outbound IPs created/managed by Azure for the cluster load balancer. Allowed values must be in the range of 1 to 100 (inclusive). The default value is 0 for single-stack and 1 for dual-stack.
 */
public data class ManagedClusterLoadBalancerProfileResponseManagedOutboundIPs(
    public val count: Int? = null,
    public val countIPv6: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.ManagedClusterLoadBalancerProfileResponseManagedOutboundIPs): ManagedClusterLoadBalancerProfileResponseManagedOutboundIPs =
            ManagedClusterLoadBalancerProfileResponseManagedOutboundIPs(
                count = javaType.count().map({ args0 -> args0 }).orElse(null),
                countIPv6 = javaType.countIPv6().map({ args0 -> args0 }).orElse(null),
            )
    }
}
