@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * Profile of the managed outbound IP resources of the managed cluster.
 * @property count The desired number of outbound IPs created/managed by Azure. Allowed values must be in the range of 1 to 16 (inclusive). The default value is 1.
 */
public data class ManagedClusterManagedOutboundIPProfileResponse(
    public val count: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.ManagedClusterManagedOutboundIPProfileResponse): ManagedClusterManagedOutboundIPProfileResponse =
            ManagedClusterManagedOutboundIPProfileResponse(
                count = javaType.count().map({ args0 -> args0 }).orElse(null),
            )
    }
}
