@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The OIDC issuer profile of the Managed Cluster.
 * @property enabled Whether the OIDC issuer is enabled.
 * @property issuerURL The OIDC issuer url of the Managed Cluster.
 */
public data class ManagedClusterOIDCIssuerProfileResponse(
    public val enabled: Boolean? = null,
    public val issuerURL: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.ManagedClusterOIDCIssuerProfileResponse): ManagedClusterOIDCIssuerProfileResponse = ManagedClusterOIDCIssuerProfileResponse(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            issuerURL = javaType.issuerURL(),
        )
    }
}
