@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * See [disable AAD Pod Identity for a specific Pod/Application](https://azure.github.io/aad-pod-identity/docs/configure/application_exception/) for more details.
 * @property name The name of the pod identity exception.
 * @property namespace The namespace of the pod identity exception.
 * @property podLabels The pod labels to match.
 */
public data class ManagedClusterPodIdentityExceptionResponse(
    public val name: String,
    public val namespace: String,
    public val podLabels: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.ManagedClusterPodIdentityExceptionResponse): ManagedClusterPodIdentityExceptionResponse = ManagedClusterPodIdentityExceptionResponse(
            name = javaType.name(),
            namespace = javaType.namespace(),
            podLabels = javaType.podLabels().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
