@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * An error response from the pod identity provisioning.
 * @property code An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
 * @property details A list of additional details about the error.
 * @property message A message describing the error, intended to be suitable for display in a user interface.
 * @property target The target of the particular error. For example, the name of the property in error.
 */
public data class ManagedClusterPodIdentityProvisioningErrorBodyResponse(
    public val code: String? = null,
    public val details: List<ManagedClusterPodIdentityProvisioningErrorBodyResponse>? = null,
    public val message: String? = null,
    public val target: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.ManagedClusterPodIdentityProvisioningErrorBodyResponse): ManagedClusterPodIdentityProvisioningErrorBodyResponse =
            ManagedClusterPodIdentityProvisioningErrorBodyResponse(
                code = javaType.code().map({ args0 -> args0 }).orElse(null),
                details = javaType.details().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterPodIdentityProvisioningErrorBodyResponse.Companion.toKotlin(args0)
                    })
                }),
                message = javaType.message().map({ args0 -> args0 }).orElse(null),
                target = javaType.target().map({ args0 -> args0 }).orElse(null),
            )
    }
}
