@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Details about the pod identity assigned to the Managed Cluster.
 * @property bindingSelector The binding selector to use for the AzureIdentityBinding resource.
 * @property identity The user assigned identity details.
 * @property name The name of the pod identity.
 * @property namespace The namespace of the pod identity.
 * @property provisioningInfo
 * @property provisioningState The current provisioning state of the pod identity.
 */
public data class ManagedClusterPodIdentityResponse(
    public val bindingSelector: String? = null,
    public val identity: UserAssignedIdentityResponse,
    public val name: String,
    public val namespace: String,
    public val provisioningInfo: ManagedClusterPodIdentityResponseProvisioningInfo,
    public val provisioningState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.ManagedClusterPodIdentityResponse): ManagedClusterPodIdentityResponse = ManagedClusterPodIdentityResponse(
            bindingSelector = javaType.bindingSelector().map({ args0 -> args0 }).orElse(null),
            identity = javaType.identity().let({ args0 ->
                com.pulumi.azurenative.containerservice.kotlin.outputs.UserAssignedIdentityResponse.Companion.toKotlin(args0)
            }),
            name = javaType.name(),
            namespace = javaType.namespace(),
            provisioningInfo = javaType.provisioningInfo().let({ args0 ->
                com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterPodIdentityResponseProvisioningInfo.Companion.toKotlin(args0)
            }),
            provisioningState = javaType.provisioningState(),
        )
    }
}
