@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * managed cluster properties for snapshot, these properties are read only.
 * @property enableRbac Whether the cluster has enabled Kubernetes Role-Based Access Control or not.
 * @property kubernetesVersion The current kubernetes version.
 * @property networkProfile The current network profile.
 * @property sku The current managed cluster sku.
 */
public data class ManagedClusterPropertiesForSnapshotResponse(
    public val enableRbac: Boolean? = null,
    public val kubernetesVersion: String? = null,
    public val networkProfile: NetworkProfileForSnapshotResponse,
    public val sku: ManagedClusterSKUResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.ManagedClusterPropertiesForSnapshotResponse): ManagedClusterPropertiesForSnapshotResponse = ManagedClusterPropertiesForSnapshotResponse(
            enableRbac = javaType.enableRbac().map({ args0 -> args0 }).orElse(null),
            kubernetesVersion = javaType.kubernetesVersion().map({ args0 -> args0 }).orElse(null),
            networkProfile = javaType.networkProfile().let({ args0 ->
                com.pulumi.azurenative.containerservice.kotlin.outputs.NetworkProfileForSnapshotResponse.Companion.toKotlin(args0)
            }),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterSKUResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
