@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Microsoft Defender settings for the security profile.
 * @property logAnalyticsWorkspaceResourceId Resource ID of the Log Analytics workspace to be associated with Microsoft Defender. When Microsoft Defender is enabled, this field is required and must be a valid workspace resource ID. When Microsoft Defender is disabled, leave the field empty.
 * @property securityMonitoring Microsoft Defender threat detection for Cloud settings for the security profile.
 */
public data class ManagedClusterSecurityProfileDefenderResponse(
    public val logAnalyticsWorkspaceResourceId: String? = null,
    public val securityMonitoring: ManagedClusterSecurityProfileDefenderSecurityMonitoringResponse? =
        null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.ManagedClusterSecurityProfileDefenderResponse): ManagedClusterSecurityProfileDefenderResponse =
            ManagedClusterSecurityProfileDefenderResponse(
                logAnalyticsWorkspaceResourceId = javaType.logAnalyticsWorkspaceResourceId().map({ args0 ->
                    args0
                }).orElse(null),
                securityMonitoring = javaType.securityMonitoring().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterSecurityProfileDefenderSecurityMonitoringResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
