@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Information about a service principal identity for the cluster to use for manipulating Azure APIs.
 * @property clientId The ID for the service principal.
 * @property secret The secret password associated with the service principal in plain text.
 */
public data class ManagedClusterServicePrincipalProfileResponse(
    public val clientId: String,
    public val secret: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.ManagedClusterServicePrincipalProfileResponse): ManagedClusterServicePrincipalProfileResponse =
            ManagedClusterServicePrincipalProfileResponse(
                clientId = javaType.clientId(),
                secret = javaType.secret().map({ args0 -> args0 }).orElse(null),
            )
    }
}
