@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * AzureBlob CSI Driver settings for the storage profile.
 * @property enabled Whether to enable AzureBlob CSI Driver. The default value is false.
 */
public data class ManagedClusterStorageProfileBlobCSIDriverResponse(
    public val enabled: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.ManagedClusterStorageProfileBlobCSIDriverResponse): ManagedClusterStorageProfileBlobCSIDriverResponse =
            ManagedClusterStorageProfileBlobCSIDriverResponse(
                enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            )
    }
}
