@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * AzureFile CSI Driver settings for the storage profile.
 * @property enabled Whether to enable AzureFile CSI Driver. The default value is true.
 */
public data class ManagedClusterStorageProfileFileCSIDriverResponse(
    public val enabled: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.ManagedClusterStorageProfileFileCSIDriverResponse): ManagedClusterStorageProfileFileCSIDriverResponse =
            ManagedClusterStorageProfileFileCSIDriverResponse(
                enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            )
    }
}
