@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.Suppress

/**
 * Storage profile for the container service cluster.
 * @property blobCSIDriver AzureBlob CSI Driver settings for the storage profile.
 * @property diskCSIDriver AzureDisk CSI Driver settings for the storage profile.
 * @property fileCSIDriver AzureFile CSI Driver settings for the storage profile.
 * @property snapshotController Snapshot Controller settings for the storage profile.
 */
public data class ManagedClusterStorageProfileResponse(
    public val blobCSIDriver: ManagedClusterStorageProfileBlobCSIDriverResponse? = null,
    public val diskCSIDriver: ManagedClusterStorageProfileDiskCSIDriverResponse? = null,
    public val fileCSIDriver: ManagedClusterStorageProfileFileCSIDriverResponse? = null,
    public val snapshotController: ManagedClusterStorageProfileSnapshotControllerResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.ManagedClusterStorageProfileResponse): ManagedClusterStorageProfileResponse = ManagedClusterStorageProfileResponse(
            blobCSIDriver = javaType.blobCSIDriver().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterStorageProfileBlobCSIDriverResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            diskCSIDriver = javaType.diskCSIDriver().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterStorageProfileDiskCSIDriverResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            fileCSIDriver = javaType.fileCSIDriver().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterStorageProfileFileCSIDriverResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            snapshotController = javaType.snapshotController().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterStorageProfileSnapshotControllerResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
