@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Profile for Windows VMs in the managed cluster.
 * @property adminPassword Specifies the password of the administrator account. <br><br> **Minimum-length:** 8 characters <br><br> **Max-length:** 123 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!"
 * @property adminUsername Specifies the name of the administrator account. <br><br> **Restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length:** 1 character <br><br> **Max-length:** 20 characters
 * @property enableCSIProxy For more details on CSI proxy, see the [CSI proxy GitHub repo](https://github.com/kubernetes-csi/csi-proxy).
 * @property gmsaProfile The Windows gMSA Profile in the Managed Cluster.
 * @property licenseType The license type to use for Windows VMs. See [Azure Hybrid User Benefits](https://azure.microsoft.com/pricing/hybrid-benefit/faq/) for more details.
 */
public data class ManagedClusterWindowsProfileResponse(
    public val adminPassword: String? = null,
    public val adminUsername: String,
    public val enableCSIProxy: Boolean? = null,
    public val gmsaProfile: WindowsGmsaProfileResponse? = null,
    public val licenseType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.ManagedClusterWindowsProfileResponse): ManagedClusterWindowsProfileResponse = ManagedClusterWindowsProfileResponse(
            adminPassword = javaType.adminPassword().map({ args0 -> args0 }).orElse(null),
            adminUsername = javaType.adminUsername(),
            enableCSIProxy = javaType.enableCSIProxy().map({ args0 -> args0 }).orElse(null),
            gmsaProfile = javaType.gmsaProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.WindowsGmsaProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            licenseType = javaType.licenseType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
