@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.Suppress

/**
 * Workload Auto-scaler profile for the managed cluster.
 * @property keda KEDA (Kubernetes Event-driven Autoscaling) settings for the workload auto-scaler profile.
 */
public data class ManagedClusterWorkloadAutoScalerProfileResponse(
    public val keda: ManagedClusterWorkloadAutoScalerProfileKedaResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.ManagedClusterWorkloadAutoScalerProfileResponse): ManagedClusterWorkloadAutoScalerProfileResponse =
            ManagedClusterWorkloadAutoScalerProfileResponse(
                keda = javaType.keda().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterWorkloadAutoScalerProfileKedaResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
