@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The status of a member update operation.
 * @property clusterResourceId The Azure resource id of the target Kubernetes cluster.
 * @property name The name of the FleetMember.
 * @property operationId The operation resource id of the latest attempt to perform the operation.
 * @property status The status of the MemberUpdate operation.
 */
public data class MemberUpdateStatusResponse(
    public val clusterResourceId: String,
    public val name: String,
    public val operationId: String,
    public val status: UpdateStatusResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.MemberUpdateStatusResponse): MemberUpdateStatusResponse = MemberUpdateStatusResponse(
            clusterResourceId = javaType.clusterResourceId(),
            name = javaType.name(),
            operationId = javaType.operationId(),
            status = javaType.status().let({ args0 ->
                com.pulumi.azurenative.containerservice.kotlin.outputs.UpdateStatusResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
