@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * network profile for managed cluster snapshot, these properties are read only.
 * @property loadBalancerSku loadBalancerSku for managed cluster snapshot.
 * @property networkMode networkMode for managed cluster snapshot.
 * @property networkPlugin networkPlugin for managed cluster snapshot.
 * @property networkPluginMode NetworkPluginMode for managed cluster snapshot.
 * @property networkPolicy networkPolicy for managed cluster snapshot.
 */
public data class NetworkProfileForSnapshotResponse(
    public val loadBalancerSku: String? = null,
    public val networkMode: String? = null,
    public val networkPlugin: String? = null,
    public val networkPluginMode: String? = null,
    public val networkPolicy: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.NetworkProfileForSnapshotResponse): NetworkProfileForSnapshotResponse = NetworkProfileForSnapshotResponse(
            loadBalancerSku = javaType.loadBalancerSku().map({ args0 -> args0 }).orElse(null),
            networkMode = javaType.networkMode().map({ args0 -> args0 }).orElse(null),
            networkPlugin = javaType.networkPlugin().map({ args0 -> args0 }).orElse(null),
            networkPluginMode = javaType.networkPluginMode().map({ args0 -> args0 }).orElse(null),
            networkPolicy = javaType.networkPolicy().map({ args0 -> args0 }).orElse(null),
        )
    }
}
