@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * Defines further properties on the API.
 * @property privateApiServer Specifies if API server is public or private.
 */
public data class OpenShiftAPIPropertiesResponse(
    public val privateApiServer: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.OpenShiftAPIPropertiesResponse): OpenShiftAPIPropertiesResponse = OpenShiftAPIPropertiesResponse(
            privateApiServer = javaType.privateApiServer().map({ args0 -> args0 }).orElse(null),
        )
    }
}
