@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the Identity provider for MS AAD.
 * @property clientId The clientId password associated with the provider.
 * @property customerAdminGroupId The groupId to be granted cluster admin role.
 * @property kind The kind of the provider.
 * Expected value is 'AADIdentityProvider'.
 * @property secret The secret password associated with the provider.
 * @property tenantId The tenantId associated with the provider.
 */
public data class OpenShiftManagedClusterAADIdentityProviderResponse(
    public val clientId: String? = null,
    public val customerAdminGroupId: String? = null,
    public val kind: String,
    public val secret: String? = null,
    public val tenantId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.OpenShiftManagedClusterAADIdentityProviderResponse): OpenShiftManagedClusterAADIdentityProviderResponse =
            OpenShiftManagedClusterAADIdentityProviderResponse(
                clientId = javaType.clientId().map({ args0 -> args0 }).orElse(null),
                customerAdminGroupId = javaType.customerAdminGroupId().map({ args0 -> args0 }).orElse(null),
                kind = javaType.kind(),
                secret = javaType.secret().map({ args0 -> args0 }).orElse(null),
                tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
            )
    }
}
