@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Represents an OpenShift router
 * @property fqdn Auto-allocated FQDN for the OpenShift router.
 * @property name Name of the router profile.
 * @property publicSubdomain DNS subdomain for OpenShift router.
 */
public data class OpenShiftRouterProfileResponse(
    public val fqdn: String,
    public val name: String? = null,
    public val publicSubdomain: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.OpenShiftRouterProfileResponse): OpenShiftRouterProfileResponse = OpenShiftRouterProfileResponse(
            fqdn = javaType.fqdn(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            publicSubdomain = javaType.publicSubdomain(),
        )
    }
}
