@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The state of a private link service connection.
 * @property description The private link service connection description.
 * @property status The private link service connection status.
 */
public data class PrivateLinkServiceConnectionStateResponse(
    public val description: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.PrivateLinkServiceConnectionStateResponse): PrivateLinkServiceConnectionStateResponse = PrivateLinkServiceConnectionStateResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
