@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * For example, between 2021-05-25T13:00:00Z and 2021-05-25T14:00:00Z.
 * @property end The end of a time span
 * @property start The start of a time span
 */
public data class TimeSpanResponse(
    public val end: String? = null,
    public val start: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.TimeSpanResponse): TimeSpanResponse = TimeSpanResponse(
            end = javaType.end().map({ args0 -> args0 }).orElse(null),
            start = javaType.start().map({ args0 -> args0 }).orElse(null),
        )
    }
}
