@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The status of a UpdateGroup.
 * @property members The list of member this UpdateGroup updates.
 * @property name The name of the UpdateGroup.
 * @property status The status of the UpdateGroup.
 */
public data class UpdateGroupStatusResponse(
    public val members: List<MemberUpdateStatusResponse>,
    public val name: String,
    public val status: UpdateStatusResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.UpdateGroupStatusResponse): UpdateGroupStatusResponse = UpdateGroupStatusResponse(
            members = javaType.members().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.MemberUpdateStatusResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            status = javaType.status().let({ args0 ->
                com.pulumi.azurenative.containerservice.kotlin.outputs.UpdateStatusResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
