@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Defines a stage which contains the groups to update and the steps to take (e.g., wait for a time period) before starting the next stage.
 * @property afterStageWaitInSeconds The time in seconds to wait at the end of this stage before starting the next one. Defaults to 0 seconds if unspecified.
 * @property groups Defines the groups to be executed in parallel in this stage. Duplicate groups are not allowed. Min size: 1.
 * @property name The name of the stage. Must be unique within the UpdateRun.
 */
public data class UpdateStageResponse(
    public val afterStageWaitInSeconds: Int? = null,
    public val groups: List<UpdateGroupResponse>? = null,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.UpdateStageResponse): UpdateStageResponse = UpdateStageResponse(
            afterStageWaitInSeconds = javaType.afterStageWaitInSeconds().map({ args0 -> args0 }).orElse(null),
            groups = javaType.groups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.UpdateGroupResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
        )
    }
}
