@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * The status of the wait duration.
 * @property status The status of the wait duration.
 * @property waitDurationInSeconds The wait duration configured in seconds.
 */
public data class WaitStatusResponse(
    public val status: UpdateStatusResponse,
    public val waitDurationInSeconds: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.WaitStatusResponse): WaitStatusResponse = WaitStatusResponse(
            status = javaType.status().let({ args0 ->
                com.pulumi.azurenative.containerservice.kotlin.outputs.UpdateStatusResponse.Companion.toKotlin(args0)
            }),
            waitDurationInSeconds = javaType.waitDurationInSeconds(),
        )
    }
}
