@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerstorage.kotlin

import com.pulumi.azurenative.containerstorage.ContainerstorageFunctions.getPoolPlain
import com.pulumi.azurenative.containerstorage.ContainerstorageFunctions.getSnapshotPlain
import com.pulumi.azurenative.containerstorage.ContainerstorageFunctions.getVolumePlain
import com.pulumi.azurenative.containerstorage.kotlin.inputs.GetPoolPlainArgs
import com.pulumi.azurenative.containerstorage.kotlin.inputs.GetPoolPlainArgsBuilder
import com.pulumi.azurenative.containerstorage.kotlin.inputs.GetSnapshotPlainArgs
import com.pulumi.azurenative.containerstorage.kotlin.inputs.GetSnapshotPlainArgsBuilder
import com.pulumi.azurenative.containerstorage.kotlin.inputs.GetVolumePlainArgs
import com.pulumi.azurenative.containerstorage.kotlin.inputs.GetVolumePlainArgsBuilder
import com.pulumi.azurenative.containerstorage.kotlin.outputs.GetPoolResult
import com.pulumi.azurenative.containerstorage.kotlin.outputs.GetSnapshotResult
import com.pulumi.azurenative.containerstorage.kotlin.outputs.GetVolumeResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.containerstorage.kotlin.outputs.GetPoolResult.Companion.toKotlin as getPoolResultToKotlin
import com.pulumi.azurenative.containerstorage.kotlin.outputs.GetSnapshotResult.Companion.toKotlin as getSnapshotResultToKotlin
import com.pulumi.azurenative.containerstorage.kotlin.outputs.GetVolumeResult.Companion.toKotlin as getVolumeResultToKotlin

public object ContainerstorageFunctions {
    /**
     * Get a Pool
     * Azure REST API version: 2023-07-01-preview.
     * @param argument null
     * @return Pool resource
     */
    public suspend fun getPool(argument: GetPoolPlainArgs): GetPoolResult =
        getPoolResultToKotlin(getPoolPlain(argument.toJava()).await())

    /**
     * @see [getPool].
     * @param poolName Pool Object
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Pool resource
     */
    public suspend fun getPool(poolName: String, resourceGroupName: String): GetPoolResult {
        val argument = GetPoolPlainArgs(
            poolName = poolName,
            resourceGroupName = resourceGroupName,
        )
        return getPoolResultToKotlin(getPoolPlain(argument.toJava()).await())
    }

    /**
     * @see [getPool].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;containerstorage&#46;kotlin&#46;inputs&#46;GetPoolPlainArgs].
     * @return Pool resource
     */
    public suspend fun getPool(argument: suspend GetPoolPlainArgsBuilder.() -> Unit): GetPoolResult {
        val builder = GetPoolPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPoolResultToKotlin(getPoolPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a Snapshot
     * Azure REST API version: 2023-07-01-preview.
     * @param argument null
     * @return Concrete proxy resource types can be created by aliasing this type using a specific property type.
     */
    public suspend fun getSnapshot(argument: GetSnapshotPlainArgs): GetSnapshotResult =
        getSnapshotResultToKotlin(getSnapshotPlain(argument.toJava()).await())

    /**
     * @see [getSnapshot].
     * @param poolName Pool Object
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param snapshotName Volume Snapshot Resource
     * @return Concrete proxy resource types can be created by aliasing this type using a specific property type.
     */
    public suspend fun getSnapshot(
        poolName: String,
        resourceGroupName: String,
        snapshotName: String,
    ): GetSnapshotResult {
        val argument = GetSnapshotPlainArgs(
            poolName = poolName,
            resourceGroupName = resourceGroupName,
            snapshotName = snapshotName,
        )
        return getSnapshotResultToKotlin(getSnapshotPlain(argument.toJava()).await())
    }

    /**
     * @see [getSnapshot].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;containerstorage&#46;kotlin&#46;inputs&#46;GetSnapshotPlainArgs].
     * @return Concrete proxy resource types can be created by aliasing this type using a specific property type.
     */
    public suspend fun getSnapshot(argument: suspend GetSnapshotPlainArgsBuilder.() -> Unit): GetSnapshotResult {
        val builder = GetSnapshotPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSnapshotResultToKotlin(getSnapshotPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a Volume
     * Azure REST API version: 2023-07-01-preview.
     * @param argument null
     * @return Concrete proxy resource types can be created by aliasing this type using a specific property type.
     */
    public suspend fun getVolume(argument: GetVolumePlainArgs): GetVolumeResult =
        getVolumeResultToKotlin(getVolumePlain(argument.toJava()).await())

    /**
     * @see [getVolume].
     * @param poolName Pool Object
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param volumeName Volume Resource
     * @return Concrete proxy resource types can be created by aliasing this type using a specific property type.
     */
    public suspend fun getVolume(
        poolName: String,
        resourceGroupName: String,
        volumeName: String,
    ): GetVolumeResult {
        val argument = GetVolumePlainArgs(
            poolName = poolName,
            resourceGroupName = resourceGroupName,
            volumeName = volumeName,
        )
        return getVolumeResultToKotlin(getVolumePlain(argument.toJava()).await())
    }

    /**
     * @see [getVolume].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;containerstorage&#46;kotlin&#46;inputs&#46;GetVolumePlainArgs].
     * @return Concrete proxy resource types can be created by aliasing this type using a specific property type.
     */
    public suspend fun getVolume(argument: suspend GetVolumePlainArgsBuilder.() -> Unit): GetVolumeResult {
        val builder = GetVolumePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVolumeResultToKotlin(getVolumePlain(builtArgument.toJava()).await())
    }
}
