@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerstorage.kotlin

import com.pulumi.azurenative.containerstorage.kotlin.outputs.AssignmentResponse
import com.pulumi.azurenative.containerstorage.kotlin.outputs.PoolTypeResponse
import com.pulumi.azurenative.containerstorage.kotlin.outputs.ResourceOperationalStatusResponse
import com.pulumi.azurenative.containerstorage.kotlin.outputs.ResourcesResponse
import com.pulumi.azurenative.containerstorage.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.containerstorage.kotlin.outputs.AssignmentResponse.Companion.toKotlin as assignmentResponseToKotlin
import com.pulumi.azurenative.containerstorage.kotlin.outputs.PoolTypeResponse.Companion.toKotlin as poolTypeResponseToKotlin
import com.pulumi.azurenative.containerstorage.kotlin.outputs.ResourceOperationalStatusResponse.Companion.toKotlin as resourceOperationalStatusResponseToKotlin
import com.pulumi.azurenative.containerstorage.kotlin.outputs.ResourcesResponse.Companion.toKotlin as resourcesResponseToKotlin
import com.pulumi.azurenative.containerstorage.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Pool].
 */
@PulumiTagMarker
public class PoolResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PoolArgs = PoolArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PoolArgsBuilder.() -> Unit) {
        val builder = PoolArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Pool {
        val builtJavaResource = com.pulumi.azurenative.containerstorage.Pool(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Pool(builtJavaResource)
    }
}

/**
 * Pool resource
 * Azure REST API version: 2023-07-01-preview. Prior API version in Azure Native 1.x: 2023-03-01-preview.
 * ## Example Usage
 * ### Pools_CreateOrUpdate_Ephemeral
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pool = new AzureNative.ContainerStorage.Pool("pool", new()
 *     {
 *         Assignments = new[]
 *         {
 *             new AzureNative.ContainerStorage.Inputs.AssignmentArgs
 *             {
 *                 Id = "/subscriptions/bb4d87a2-4273-466c-a6ba-61d818061b3a/resourceGroups/test-rg/providers/Microsoft.ContainerService/managedClusters/containerstoragetest",
 *             },
 *         },
 *         Location = "eastus",
 *         PoolName = "test-pool",
 *         PoolType = new AzureNative.ContainerStorage.Inputs.PoolTypeArgs
 *         {
 *             EphemeralDisk = new AzureNative.ContainerStorage.Inputs.EphemeralDiskArgs
 *             {
 *                 Replicas = 3,
 *             },
 *         },
 *         ReclaimPolicy = AzureNative.ContainerStorage.ReclaimPolicy.Delete,
 *         ResourceGroupName = "test-rg",
 *         Resources = new AzureNative.ContainerStorage.Inputs.ResourcesArgs
 *         {
 *             Requests = new AzureNative.ContainerStorage.Inputs.RequestsArgs
 *             {
 *                 Storage = 15578,
 *             },
 *         },
 *         Tags =
 *         {
 *             { "key1888", "value1888" },
 *         },
 *         Zones = new[]
 *         {
 *             AzureNative.ContainerStorage.Zone.Zone1,
 *             AzureNative.ContainerStorage.Zone.Zone2,
 *             AzureNative.ContainerStorage.Zone.Zone3,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerstorage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerstorage.NewPool(ctx, "pool", &containerstorage.PoolArgs{
 * 			Assignments: containerstorage.AssignmentArray{
 * 				&containerstorage.AssignmentArgs{
 * 					Id: pulumi.String("/subscriptions/bb4d87a2-4273-466c-a6ba-61d818061b3a/resourceGroups/test-rg/providers/Microsoft.ContainerService/managedClusters/containerstoragetest"),
 * 				},
 * 			},
 * 			Location: pulumi.String("eastus"),
 * 			PoolName: pulumi.String("test-pool"),
 * 			PoolType: &containerstorage.PoolTypeArgs{
 * 				EphemeralDisk: &containerstorage.EphemeralDiskArgs{
 * 					Replicas: pulumi.Float64(3),
 * 				},
 * 			},
 * 			ReclaimPolicy:     pulumi.String(containerstorage.ReclaimPolicyDelete),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			Resources: &containerstorage.ResourcesArgs{
 * 				Requests: &containerstorage.RequestsArgs{
 * 					Storage: pulumi.Float64(15578),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1888": pulumi.String("value1888"),
 * 			},
 * 			Zones: pulumi.StringArray{
 * 				pulumi.String(containerstorage.ZoneZone1),
 * 				pulumi.String(containerstorage.ZoneZone2),
 * 				pulumi.String(containerstorage.ZoneZone3),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerstorage.Pool;
 * import com.pulumi.azurenative.containerstorage.PoolArgs;
 * import com.pulumi.azurenative.containerstorage.inputs.AssignmentArgs;
 * import com.pulumi.azurenative.containerstorage.inputs.PoolTypeArgs;
 * import com.pulumi.azurenative.containerstorage.inputs.EphemeralDiskArgs;
 * import com.pulumi.azurenative.containerstorage.inputs.ResourcesArgs;
 * import com.pulumi.azurenative.containerstorage.inputs.RequestsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pool = new Pool("pool", PoolArgs.builder()
 *             .assignments(AssignmentArgs.builder()
 *                 .id("/subscriptions/bb4d87a2-4273-466c-a6ba-61d818061b3a/resourceGroups/test-rg/providers/Microsoft.ContainerService/managedClusters/containerstoragetest")
 *                 .build())
 *             .location("eastus")
 *             .poolName("test-pool")
 *             .poolType(PoolTypeArgs.builder()
 *                 .ephemeralDisk(EphemeralDiskArgs.builder()
 *                     .replicas(3)
 *                     .build())
 *                 .build())
 *             .reclaimPolicy("Delete")
 *             .resourceGroupName("test-rg")
 *             .resources(ResourcesArgs.builder()
 *                 .requests(RequestsArgs.builder()
 *                     .storage(15578)
 *                     .build())
 *                 .build())
 *             .tags(Map.of("key1888", "value1888"))
 *             .zones(
 *                 "1",
 *                 "2",
 *                 "3")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerstorage:Pool test-pool /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerStorage/pools/{poolName}
 * ```
 */
public class Pool internal constructor(
    override val javaResource: com.pulumi.azurenative.containerstorage.Pool,
) : KotlinCustomResource(javaResource, PoolMapper) {
    /**
     * List of resources that should have access to the pool. Typically ARM references to AKS clusters or ACI Container Groups. For local and standard this must be a single reference. For ElasticSAN there can be many.
     */
    public val assignments: Output<List<AssignmentResponse>>?
        get() = javaResource.assignments().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> assignmentResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Type of the Pool: ephemeralDisk, azureDisk, or elasticsan.
     */
    public val poolType: Output<PoolTypeResponse>
        get() = javaResource.poolType().applyValue({ args0 ->
            args0.let({ args0 ->
                poolTypeResponseToKotlin(args0)
            })
        })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * ReclaimPolicy defines what happens to the backend storage when StoragePool is deleted
     */
    public val reclaimPolicy: Output<String>?
        get() = javaResource.reclaimPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resources represent the resources the pool should have.
     */
    public val resources: Output<ResourcesResponse>?
        get() = javaResource.resources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourcesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The operational status of the resource
     */
    public val status: Output<ResourceOperationalStatusResponse>
        get() = javaResource.status().applyValue({ args0 ->
            args0.let({ args0 ->
                resourceOperationalStatusResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * List of availability zones that resources can be created in.
     */
    public val zones: Output<List<String>>?
        get() = javaResource.zones().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object PoolMapper : ResourceMapper<Pool> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.containerstorage.Pool::class == javaResource::class

    override fun map(javaResource: Resource): Pool = Pool(
        javaResource as
            com.pulumi.azurenative.containerstorage.Pool,
    )
}

/**
 * @see [Pool].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Pool].
 */
public suspend fun pool(name: String, block: suspend PoolResourceBuilder.() -> Unit): Pool {
    val builder = PoolResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Pool].
 * @param name The _unique_ name of the resulting resource.
 */
public fun pool(name: String): Pool {
    val builder = PoolResourceBuilder()
    builder.name(name)
    return builder.build()
}
