@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerstorage.kotlin

import com.pulumi.azurenative.containerstorage.PoolArgs.builder
import com.pulumi.azurenative.containerstorage.kotlin.enums.ReclaimPolicy
import com.pulumi.azurenative.containerstorage.kotlin.enums.Zone
import com.pulumi.azurenative.containerstorage.kotlin.inputs.AssignmentArgs
import com.pulumi.azurenative.containerstorage.kotlin.inputs.AssignmentArgsBuilder
import com.pulumi.azurenative.containerstorage.kotlin.inputs.PoolTypeArgs
import com.pulumi.azurenative.containerstorage.kotlin.inputs.PoolTypeArgsBuilder
import com.pulumi.azurenative.containerstorage.kotlin.inputs.ResourcesArgs
import com.pulumi.azurenative.containerstorage.kotlin.inputs.ResourcesArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Pool resource
 * Azure REST API version: 2023-07-01-preview. Prior API version in Azure Native 1.x: 2023-03-01-preview.
 * ## Example Usage
 * ### Pools_CreateOrUpdate_Ephemeral
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pool = new AzureNative.ContainerStorage.Pool("pool", new()
 *     {
 *         Assignments = new[]
 *         {
 *             new AzureNative.ContainerStorage.Inputs.AssignmentArgs
 *             {
 *                 Id = "/subscriptions/bb4d87a2-4273-466c-a6ba-61d818061b3a/resourceGroups/test-rg/providers/Microsoft.ContainerService/managedClusters/containerstoragetest",
 *             },
 *         },
 *         Location = "eastus",
 *         PoolName = "test-pool",
 *         PoolType = new AzureNative.ContainerStorage.Inputs.PoolTypeArgs
 *         {
 *             EphemeralDisk = new AzureNative.ContainerStorage.Inputs.EphemeralDiskArgs
 *             {
 *                 Replicas = 3,
 *             },
 *         },
 *         ReclaimPolicy = AzureNative.ContainerStorage.ReclaimPolicy.Delete,
 *         ResourceGroupName = "test-rg",
 *         Resources = new AzureNative.ContainerStorage.Inputs.ResourcesArgs
 *         {
 *             Requests = new AzureNative.ContainerStorage.Inputs.RequestsArgs
 *             {
 *                 Storage = 15578,
 *             },
 *         },
 *         Tags =
 *         {
 *             { "key1888", "value1888" },
 *         },
 *         Zones = new[]
 *         {
 *             AzureNative.ContainerStorage.Zone.Zone1,
 *             AzureNative.ContainerStorage.Zone.Zone2,
 *             AzureNative.ContainerStorage.Zone.Zone3,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerstorage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerstorage.NewPool(ctx, "pool", &containerstorage.PoolArgs{
 * 			Assignments: containerstorage.AssignmentArray{
 * 				&containerstorage.AssignmentArgs{
 * 					Id: pulumi.String("/subscriptions/bb4d87a2-4273-466c-a6ba-61d818061b3a/resourceGroups/test-rg/providers/Microsoft.ContainerService/managedClusters/containerstoragetest"),
 * 				},
 * 			},
 * 			Location: pulumi.String("eastus"),
 * 			PoolName: pulumi.String("test-pool"),
 * 			PoolType: &containerstorage.PoolTypeArgs{
 * 				EphemeralDisk: &containerstorage.EphemeralDiskArgs{
 * 					Replicas: pulumi.Float64(3),
 * 				},
 * 			},
 * 			ReclaimPolicy:     pulumi.String(containerstorage.ReclaimPolicyDelete),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			Resources: &containerstorage.ResourcesArgs{
 * 				Requests: &containerstorage.RequestsArgs{
 * 					Storage: pulumi.Float64(15578),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1888": pulumi.String("value1888"),
 * 			},
 * 			Zones: pulumi.StringArray{
 * 				pulumi.String(containerstorage.ZoneZone1),
 * 				pulumi.String(containerstorage.ZoneZone2),
 * 				pulumi.String(containerstorage.ZoneZone3),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerstorage.Pool;
 * import com.pulumi.azurenative.containerstorage.PoolArgs;
 * import com.pulumi.azurenative.containerstorage.inputs.AssignmentArgs;
 * import com.pulumi.azurenative.containerstorage.inputs.PoolTypeArgs;
 * import com.pulumi.azurenative.containerstorage.inputs.EphemeralDiskArgs;
 * import com.pulumi.azurenative.containerstorage.inputs.ResourcesArgs;
 * import com.pulumi.azurenative.containerstorage.inputs.RequestsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pool = new Pool("pool", PoolArgs.builder()
 *             .assignments(AssignmentArgs.builder()
 *                 .id("/subscriptions/bb4d87a2-4273-466c-a6ba-61d818061b3a/resourceGroups/test-rg/providers/Microsoft.ContainerService/managedClusters/containerstoragetest")
 *                 .build())
 *             .location("eastus")
 *             .poolName("test-pool")
 *             .poolType(PoolTypeArgs.builder()
 *                 .ephemeralDisk(EphemeralDiskArgs.builder()
 *                     .replicas(3)
 *                     .build())
 *                 .build())
 *             .reclaimPolicy("Delete")
 *             .resourceGroupName("test-rg")
 *             .resources(ResourcesArgs.builder()
 *                 .requests(RequestsArgs.builder()
 *                     .storage(15578)
 *                     .build())
 *                 .build())
 *             .tags(Map.of("key1888", "value1888"))
 *             .zones(
 *                 "1",
 *                 "2",
 *                 "3")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerstorage:Pool test-pool /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerStorage/pools/{poolName}
 * ```
 * @property assignments List of resources that should have access to the pool. Typically ARM references to AKS clusters or ACI Container Groups. For local and standard this must be a single reference. For ElasticSAN there can be many.
 * @property location The geo-location where the resource lives
 * @property poolName Pool Object
 * @property poolType Type of the Pool: ephemeralDisk, azureDisk, or elasticsan.
 * @property reclaimPolicy ReclaimPolicy defines what happens to the backend storage when StoragePool is deleted
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resources Resources represent the resources the pool should have.
 * @property tags Resource tags.
 * @property zones List of availability zones that resources can be created in.
 */
public data class PoolArgs(
    public val assignments: Output<List<AssignmentArgs>>? = null,
    public val location: Output<String>? = null,
    public val poolName: Output<String>? = null,
    public val poolType: Output<PoolTypeArgs>? = null,
    public val reclaimPolicy: Output<Either<String, ReclaimPolicy>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resources: Output<ResourcesArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val zones: Output<List<Either<String, Zone>>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerstorage.PoolArgs> {
    override fun toJava(): com.pulumi.azurenative.containerstorage.PoolArgs =
        com.pulumi.azurenative.containerstorage.PoolArgs.builder()
            .assignments(
                assignments?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .poolName(poolName?.applyValue({ args0 -> args0 }))
            .poolType(poolType?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .reclaimPolicy(
                reclaimPolicy?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resources(resources?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .zones(
                zones?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 ->
                            args0.let({ args0 -> args0.toJava() })
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [PoolArgs].
 */
@PulumiTagMarker
public class PoolArgsBuilder internal constructor() {
    private var assignments: Output<List<AssignmentArgs>>? = null

    private var location: Output<String>? = null

    private var poolName: Output<String>? = null

    private var poolType: Output<PoolTypeArgs>? = null

    private var reclaimPolicy: Output<Either<String, ReclaimPolicy>>? = null

    private var resourceGroupName: Output<String>? = null

    private var resources: Output<ResourcesArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var zones: Output<List<Either<String, Zone>>>? = null

    /**
     * @param value List of resources that should have access to the pool. Typically ARM references to AKS clusters or ACI Container Groups. For local and standard this must be a single reference. For ElasticSAN there can be many.
     */
    @JvmName("ludvnkfqitsvifqf")
    public suspend fun assignments(`value`: Output<List<AssignmentArgs>>) {
        this.assignments = value
    }

    @JvmName("dkrkghapmnsvrqit")
    public suspend fun assignments(vararg values: Output<AssignmentArgs>) {
        this.assignments = Output.all(values.asList())
    }

    /**
     * @param values List of resources that should have access to the pool. Typically ARM references to AKS clusters or ACI Container Groups. For local and standard this must be a single reference. For ElasticSAN there can be many.
     */
    @JvmName("sjsmdqicrfwayjlb")
    public suspend fun assignments(values: List<Output<AssignmentArgs>>) {
        this.assignments = Output.all(values)
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("djtwdnuntcrodjna")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Pool Object
     */
    @JvmName("pgojwgblhgdrdpce")
    public suspend fun poolName(`value`: Output<String>) {
        this.poolName = value
    }

    /**
     * @param value Type of the Pool: ephemeralDisk, azureDisk, or elasticsan.
     */
    @JvmName("kevegrhdrlbkdalc")
    public suspend fun poolType(`value`: Output<PoolTypeArgs>) {
        this.poolType = value
    }

    /**
     * @param value ReclaimPolicy defines what happens to the backend storage when StoragePool is deleted
     */
    @JvmName("duwnvuedoetimuts")
    public suspend fun reclaimPolicy(`value`: Output<Either<String, ReclaimPolicy>>) {
        this.reclaimPolicy = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("eqfoksiqmcfxgfbw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resources represent the resources the pool should have.
     */
    @JvmName("rojrpwxylkbmabhk")
    public suspend fun resources(`value`: Output<ResourcesArgs>) {
        this.resources = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("vyfbejjdvgglkdjh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value List of availability zones that resources can be created in.
     */
    @JvmName("pitjcpoyhuksjabi")
    public suspend fun zones(`value`: Output<List<Either<String, Zone>>>) {
        this.zones = value
    }

    @JvmName("ximutgigitgwspbq")
    public suspend fun zones(vararg values: Output<Either<String, Zone>>) {
        this.zones = Output.all(values.asList())
    }

    /**
     * @param values List of availability zones that resources can be created in.
     */
    @JvmName("dqieudmsaxpuibgl")
    public suspend fun zones(values: List<Output<Either<String, Zone>>>) {
        this.zones = Output.all(values)
    }

    /**
     * @param value List of resources that should have access to the pool. Typically ARM references to AKS clusters or ACI Container Groups. For local and standard this must be a single reference. For ElasticSAN there can be many.
     */
    @JvmName("wohhxtnnnpmjentu")
    public suspend fun assignments(`value`: List<AssignmentArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assignments = mapped
    }

    /**
     * @param argument List of resources that should have access to the pool. Typically ARM references to AKS clusters or ACI Container Groups. For local and standard this must be a single reference. For ElasticSAN there can be many.
     */
    @JvmName("xjvvlyhnfdjegljp")
    public suspend fun assignments(argument: List<suspend AssignmentArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { AssignmentArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.assignments = mapped
    }

    /**
     * @param argument List of resources that should have access to the pool. Typically ARM references to AKS clusters or ACI Container Groups. For local and standard this must be a single reference. For ElasticSAN there can be many.
     */
    @JvmName("xqqhqetnteygbgii")
    public suspend fun assignments(vararg argument: suspend AssignmentArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { AssignmentArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.assignments = mapped
    }

    /**
     * @param argument List of resources that should have access to the pool. Typically ARM references to AKS clusters or ACI Container Groups. For local and standard this must be a single reference. For ElasticSAN there can be many.
     */
    @JvmName("avnbxeosxjogggiq")
    public suspend fun assignments(argument: suspend AssignmentArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AssignmentArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.assignments = mapped
    }

    /**
     * @param values List of resources that should have access to the pool. Typically ARM references to AKS clusters or ACI Container Groups. For local and standard this must be a single reference. For ElasticSAN there can be many.
     */
    @JvmName("nfveehhsgnmgdhyo")
    public suspend fun assignments(vararg values: AssignmentArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.assignments = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("qfvpxmjrdcfmghla")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Pool Object
     */
    @JvmName("ygnlggneuavgonyb")
    public suspend fun poolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.poolName = mapped
    }

    /**
     * @param value Type of the Pool: ephemeralDisk, azureDisk, or elasticsan.
     */
    @JvmName("xvkslrktnihtycxy")
    public suspend fun poolType(`value`: PoolTypeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.poolType = mapped
    }

    /**
     * @param argument Type of the Pool: ephemeralDisk, azureDisk, or elasticsan.
     */
    @JvmName("qwnttuqjorcfujps")
    public suspend fun poolType(argument: suspend PoolTypeArgsBuilder.() -> Unit) {
        val toBeMapped = PoolTypeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.poolType = mapped
    }

    /**
     * @param value ReclaimPolicy defines what happens to the backend storage when StoragePool is deleted
     */
    @JvmName("appfltmjofaumfiw")
    public suspend fun reclaimPolicy(`value`: Either<String, ReclaimPolicy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reclaimPolicy = mapped
    }

    /**
     * @param value ReclaimPolicy defines what happens to the backend storage when StoragePool is deleted
     */
    @JvmName("xkhmmqowmijfqmdk")
    public fun reclaimPolicy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ReclaimPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.reclaimPolicy = mapped
    }

    /**
     * @param value ReclaimPolicy defines what happens to the backend storage when StoragePool is deleted
     */
    @JvmName("ccvodbsckcdfuofm")
    public fun reclaimPolicy(`value`: ReclaimPolicy) {
        val toBeMapped = Either.ofRight<String, ReclaimPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.reclaimPolicy = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("njnpxqtgdddixjgx")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resources represent the resources the pool should have.
     */
    @JvmName("cuenvhoticnbaiba")
    public suspend fun resources(`value`: ResourcesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resources = mapped
    }

    /**
     * @param argument Resources represent the resources the pool should have.
     */
    @JvmName("wttfrlhmjbydhqha")
    public suspend fun resources(argument: suspend ResourcesArgsBuilder.() -> Unit) {
        val toBeMapped = ResourcesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.resources = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("wthatbpvjhvaloiu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("jptlvsicwehgrwxw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value List of availability zones that resources can be created in.
     */
    @JvmName("yckfhmtjhawrjhmb")
    public suspend fun zones(`value`: List<Either<String, Zone>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    /**
     * @param values List of availability zones that resources can be created in.
     */
    @JvmName("ccxppcoqeimkyrrb")
    public suspend fun zones(vararg values: Either<String, Zone>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    internal fun build(): PoolArgs = PoolArgs(
        assignments = assignments,
        location = location,
        poolName = poolName,
        poolType = poolType,
        reclaimPolicy = reclaimPolicy,
        resourceGroupName = resourceGroupName,
        resources = resources,
        tags = tags,
        zones = zones,
    )
}
