@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerstorage.kotlin

import com.pulumi.azurenative.containerstorage.kotlin.outputs.ResourceOperationalStatusResponse
import com.pulumi.azurenative.containerstorage.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.containerstorage.kotlin.outputs.VolumeTypeResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.containerstorage.kotlin.outputs.ResourceOperationalStatusResponse.Companion.toKotlin as resourceOperationalStatusResponseToKotlin
import com.pulumi.azurenative.containerstorage.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.containerstorage.kotlin.outputs.VolumeTypeResponse.Companion.toKotlin as volumeTypeResponseToKotlin

/**
 * Builder for [Volume].
 */
@PulumiTagMarker
public class VolumeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VolumeArgs = VolumeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VolumeArgsBuilder.() -> Unit) {
        val builder = VolumeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Volume {
        val builtJavaResource = com.pulumi.azurenative.containerstorage.Volume(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Volume(builtJavaResource)
    }
}

/**
 * Concrete proxy resource types can be created by aliasing this type using a specific property type.
 * Azure REST API version: 2023-07-01-preview. Prior API version in Azure Native 1.x: 2023-03-01-preview.
 * ## Example Usage
 * ### Volumes_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var volume = new AzureNative.ContainerStorage.Volume("volume", new()
 *     {
 *         CapacityGiB = 25838,
 *         Labels =
 *         {
 *             { "key2039", "value2039" },
 *         },
 *         PoolName = "test-pool",
 *         ResourceGroupName = "test-rg",
 *         VolumeName = "test-volume",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerstorage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerstorage.NewVolume(ctx, "volume", &containerstorage.VolumeArgs{
 * 			CapacityGiB: pulumi.Float64(25838),
 * 			Labels: pulumi.StringMap{
 * 				"key2039": pulumi.String("value2039"),
 * 			},
 * 			PoolName:          pulumi.String("test-pool"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			VolumeName:        pulumi.String("test-volume"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerstorage.Volume;
 * import com.pulumi.azurenative.containerstorage.VolumeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var volume = new Volume("volume", VolumeArgs.builder()
 *             .capacityGiB(25838)
 *             .labels(Map.of("key2039", "value2039"))
 *             .poolName("test-pool")
 *             .resourceGroupName("test-rg")
 *             .volumeName("test-volume")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerstorage:Volume test-volume /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerStorage/pools/{poolName}/volumes/{volumeName}
 * ```
 */
public class Volume internal constructor(
    override val javaResource: com.pulumi.azurenative.containerstorage.Volume,
) : KotlinCustomResource(javaResource, VolumeMapper) {
    /**
     * Requested capacity in GiB
     */
    public val capacityGiB: Output<Double>
        get() = javaResource.capacityGiB().applyValue({ args0 -> args0 })

    /**
     * String KV pairs indicating labels
     */
    public val labels: Output<Map<String, String>>
        get() = javaResource.labels().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The status of the resource.
     */
    public val status: Output<ResourceOperationalStatusResponse>
        get() = javaResource.status().applyValue({ args0 ->
            args0.let({ args0 ->
                resourceOperationalStatusResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Properties of the volume
     */
    public val volumeType: Output<VolumeTypeResponse>
        get() = javaResource.volumeType().applyValue({ args0 ->
            args0.let({ args0 ->
                volumeTypeResponseToKotlin(args0)
            })
        })
}

public object VolumeMapper : ResourceMapper<Volume> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.containerstorage.Volume::class == javaResource::class

    override fun map(javaResource: Resource): Volume = Volume(
        javaResource as
            com.pulumi.azurenative.containerstorage.Volume,
    )
}

/**
 * @see [Volume].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Volume].
 */
public suspend fun volume(name: String, block: suspend VolumeResourceBuilder.() -> Unit): Volume {
    val builder = VolumeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Volume].
 * @param name The _unique_ name of the resulting resource.
 */
public fun volume(name: String): Volume {
    val builder = VolumeResourceBuilder()
    builder.name(name)
    return builder.build()
}
