@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerstorage.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * ReclaimPolicy defines what happens to the backend storage when StoragePool is deleted
 */
public enum class ReclaimPolicy(
    public val javaValue: com.pulumi.azurenative.containerstorage.enums.ReclaimPolicy,
) : ConvertibleToJava<com.pulumi.azurenative.containerstorage.enums.ReclaimPolicy> {
    /**
     * Delete resource
     */
    Delete(com.pulumi.azurenative.containerstorage.enums.ReclaimPolicy.Delete),

    /**
     * Retain resource
     */
    Retain(com.pulumi.azurenative.containerstorage.enums.ReclaimPolicy.Retain),
    ;

    override fun toJava(): com.pulumi.azurenative.containerstorage.enums.ReclaimPolicy = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerstorage.enums.ReclaimPolicy): ReclaimPolicy = ReclaimPolicy.values().first { it.javaValue == javaType }
    }
}
