@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerstorage.kotlin.inputs

import com.pulumi.azurenative.containerstorage.inputs.AzureDiskArgs.builder
import com.pulumi.azurenative.containerstorage.kotlin.enums.AzureDiskSkuName
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Azure Disk Pool Properties
 * @property disks Only required if individual disk selection is desired. Path to disk, e.g. <nodename>:/dev/sda or WWN. Supports specifying multiple disks (same syntax as tags).
 * @property encryption Encryption specifies the encryption configuration for the Azure Disk pool
 * @property skuName Sku name
 */
public data class AzureDiskArgs(
    public val disks: Output<List<DiskArgs>>? = null,
    public val encryption: Output<EncryptionArgs>? = null,
    public val skuName: Output<Either<String, AzureDiskSkuName>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerstorage.inputs.AzureDiskArgs> {
    override fun toJava(): com.pulumi.azurenative.containerstorage.inputs.AzureDiskArgs =
        com.pulumi.azurenative.containerstorage.inputs.AzureDiskArgs.builder()
            .disks(disks?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .encryption(encryption?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .skuName(
                skuName?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [AzureDiskArgs].
 */
@PulumiTagMarker
public class AzureDiskArgsBuilder internal constructor() {
    private var disks: Output<List<DiskArgs>>? = null

    private var encryption: Output<EncryptionArgs>? = null

    private var skuName: Output<Either<String, AzureDiskSkuName>>? = null

    /**
     * @param value Only required if individual disk selection is desired. Path to disk, e.g. <nodename>:/dev/sda or WWN. Supports specifying multiple disks (same syntax as tags).
     */
    @JvmName("ehphequefkjabglq")
    public suspend fun disks(`value`: Output<List<DiskArgs>>) {
        this.disks = value
    }

    @JvmName("ccrxkgqimrnqaimt")
    public suspend fun disks(vararg values: Output<DiskArgs>) {
        this.disks = Output.all(values.asList())
    }

    /**
     * @param values Only required if individual disk selection is desired. Path to disk, e.g. <nodename>:/dev/sda or WWN. Supports specifying multiple disks (same syntax as tags).
     */
    @JvmName("svqtxxohxxrbmcvs")
    public suspend fun disks(values: List<Output<DiskArgs>>) {
        this.disks = Output.all(values)
    }

    /**
     * @param value Encryption specifies the encryption configuration for the Azure Disk pool
     */
    @JvmName("sxkswnsubpakvxny")
    public suspend fun encryption(`value`: Output<EncryptionArgs>) {
        this.encryption = value
    }

    /**
     * @param value Sku name
     */
    @JvmName("nxjwvhugcapbrgds")
    public suspend fun skuName(`value`: Output<Either<String, AzureDiskSkuName>>) {
        this.skuName = value
    }

    /**
     * @param value Only required if individual disk selection is desired. Path to disk, e.g. <nodename>:/dev/sda or WWN. Supports specifying multiple disks (same syntax as tags).
     */
    @JvmName("mslqxftofuequmom")
    public suspend fun disks(`value`: List<DiskArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disks = mapped
    }

    /**
     * @param argument Only required if individual disk selection is desired. Path to disk, e.g. <nodename>:/dev/sda or WWN. Supports specifying multiple disks (same syntax as tags).
     */
    @JvmName("gndnbnsrchjlpsie")
    public suspend fun disks(argument: List<suspend DiskArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { DiskArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.disks = mapped
    }

    /**
     * @param argument Only required if individual disk selection is desired. Path to disk, e.g. <nodename>:/dev/sda or WWN. Supports specifying multiple disks (same syntax as tags).
     */
    @JvmName("bhsqffdsonqadesw")
    public suspend fun disks(vararg argument: suspend DiskArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { DiskArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.disks = mapped
    }

    /**
     * @param argument Only required if individual disk selection is desired. Path to disk, e.g. <nodename>:/dev/sda or WWN. Supports specifying multiple disks (same syntax as tags).
     */
    @JvmName("ingmbcnnywcuojfq")
    public suspend fun disks(argument: suspend DiskArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DiskArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.disks = mapped
    }

    /**
     * @param values Only required if individual disk selection is desired. Path to disk, e.g. <nodename>:/dev/sda or WWN. Supports specifying multiple disks (same syntax as tags).
     */
    @JvmName("hvqiqrkrckfapepu")
    public suspend fun disks(vararg values: DiskArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.disks = mapped
    }

    /**
     * @param value Encryption specifies the encryption configuration for the Azure Disk pool
     */
    @JvmName("diitgfixqhcjailt")
    public suspend fun encryption(`value`: EncryptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryption = mapped
    }

    /**
     * @param argument Encryption specifies the encryption configuration for the Azure Disk pool
     */
    @JvmName("ubmslijxumslpjho")
    public suspend fun encryption(argument: suspend EncryptionArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryption = mapped
    }

    /**
     * @param value Sku name
     */
    @JvmName("upwkyxlcndkxcvab")
    public suspend fun skuName(`value`: Either<String, AzureDiskSkuName>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skuName = mapped
    }

    /**
     * @param value Sku name
     */
    @JvmName("rwpbwdojmglibqni")
    public fun skuName(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureDiskSkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.skuName = mapped
    }

    /**
     * @param value Sku name
     */
    @JvmName("wxmlwyeusihrbjys")
    public fun skuName(`value`: AzureDiskSkuName) {
        val toBeMapped = Either.ofRight<String, AzureDiskSkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.skuName = mapped
    }

    internal fun build(): AzureDiskArgs = AzureDiskArgs(
        disks = disks,
        encryption = encryption,
        skuName = skuName,
    )
}
