@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerstorage.kotlin.inputs

import com.pulumi.azurenative.containerstorage.inputs.EphemeralDiskArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Ephemeral Disk Pool Properties
 * @property disks Only required if individual disk selection is desired. Path to disk, e.g. <nodename>:/dev/sda or WWN. Supports specifying multiple disks (same syntax as tags).
 * @property replicas The number of data copies. Default 3.
 */
public data class EphemeralDiskArgs(
    public val disks: Output<List<DiskArgs>>? = null,
    public val replicas: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerstorage.inputs.EphemeralDiskArgs> {
    override fun toJava(): com.pulumi.azurenative.containerstorage.inputs.EphemeralDiskArgs =
        com.pulumi.azurenative.containerstorage.inputs.EphemeralDiskArgs.builder()
            .disks(disks?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .replicas(replicas?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EphemeralDiskArgs].
 */
@PulumiTagMarker
public class EphemeralDiskArgsBuilder internal constructor() {
    private var disks: Output<List<DiskArgs>>? = null

    private var replicas: Output<Double>? = null

    /**
     * @param value Only required if individual disk selection is desired. Path to disk, e.g. <nodename>:/dev/sda or WWN. Supports specifying multiple disks (same syntax as tags).
     */
    @JvmName("jjiiskciqabpqypr")
    public suspend fun disks(`value`: Output<List<DiskArgs>>) {
        this.disks = value
    }

    @JvmName("eoxuylxbhyhbdqwh")
    public suspend fun disks(vararg values: Output<DiskArgs>) {
        this.disks = Output.all(values.asList())
    }

    /**
     * @param values Only required if individual disk selection is desired. Path to disk, e.g. <nodename>:/dev/sda or WWN. Supports specifying multiple disks (same syntax as tags).
     */
    @JvmName("yqohhofikofkhkal")
    public suspend fun disks(values: List<Output<DiskArgs>>) {
        this.disks = Output.all(values)
    }

    /**
     * @param value The number of data copies. Default 3.
     */
    @JvmName("dphlldmjdqbmwvmx")
    public suspend fun replicas(`value`: Output<Double>) {
        this.replicas = value
    }

    /**
     * @param value Only required if individual disk selection is desired. Path to disk, e.g. <nodename>:/dev/sda or WWN. Supports specifying multiple disks (same syntax as tags).
     */
    @JvmName("ypilqbsbuenwsxtx")
    public suspend fun disks(`value`: List<DiskArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disks = mapped
    }

    /**
     * @param argument Only required if individual disk selection is desired. Path to disk, e.g. <nodename>:/dev/sda or WWN. Supports specifying multiple disks (same syntax as tags).
     */
    @JvmName("pbuojjisqdamgcdn")
    public suspend fun disks(argument: List<suspend DiskArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { DiskArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.disks = mapped
    }

    /**
     * @param argument Only required if individual disk selection is desired. Path to disk, e.g. <nodename>:/dev/sda or WWN. Supports specifying multiple disks (same syntax as tags).
     */
    @JvmName("tqsviwvqmmwpfmus")
    public suspend fun disks(vararg argument: suspend DiskArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { DiskArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.disks = mapped
    }

    /**
     * @param argument Only required if individual disk selection is desired. Path to disk, e.g. <nodename>:/dev/sda or WWN. Supports specifying multiple disks (same syntax as tags).
     */
    @JvmName("okppnbirhdabwvel")
    public suspend fun disks(argument: suspend DiskArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DiskArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.disks = mapped
    }

    /**
     * @param values Only required if individual disk selection is desired. Path to disk, e.g. <nodename>:/dev/sda or WWN. Supports specifying multiple disks (same syntax as tags).
     */
    @JvmName("yjfnugpegicfaifs")
    public suspend fun disks(vararg values: DiskArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.disks = mapped
    }

    /**
     * @param value The number of data copies. Default 3.
     */
    @JvmName("mtvejhrhieajiaym")
    public suspend fun replicas(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicas = mapped
    }

    internal fun build(): EphemeralDiskArgs = EphemeralDiskArgs(
        disks = disks,
        replicas = replicas,
    )
}
