@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerstorage.kotlin.inputs

import com.pulumi.azurenative.containerstorage.inputs.RequestsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Requests for capacity for the pool.
 * @property storage Requested capacity of the pool in GiB.
 */
public data class RequestsArgs(
    public val storage: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerstorage.inputs.RequestsArgs> {
    override fun toJava(): com.pulumi.azurenative.containerstorage.inputs.RequestsArgs =
        com.pulumi.azurenative.containerstorage.inputs.RequestsArgs.builder()
            .storage(storage?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RequestsArgs].
 */
@PulumiTagMarker
public class RequestsArgsBuilder internal constructor() {
    private var storage: Output<Double>? = null

    /**
     * @param value Requested capacity of the pool in GiB.
     */
    @JvmName("ysoulgwwtjewbbnw")
    public suspend fun storage(`value`: Output<Double>) {
        this.storage = value
    }

    /**
     * @param value Requested capacity of the pool in GiB.
     */
    @JvmName("kbfwdpdylnxhulgu")
    public suspend fun storage(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storage = mapped
    }

    internal fun build(): RequestsArgs = RequestsArgs(
        storage = storage,
    )
}
