@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerstorage.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Azure Disk Pool Properties
 * @property disks Only required if individual disk selection is desired. Path to disk, e.g. <nodename>:/dev/sda or WWN. Supports specifying multiple disks (same syntax as tags).
 * @property encryption Encryption specifies the encryption configuration for the Azure Disk pool
 * @property resourceGroup Managed resource group for the pool.
 * @property skuName Sku name
 */
public data class AzureDiskResponse(
    public val disks: List<DiskResponse>? = null,
    public val encryption: EncryptionResponse? = null,
    public val resourceGroup: String,
    public val skuName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerstorage.outputs.AzureDiskResponse): AzureDiskResponse = AzureDiskResponse(
            disks = javaType.disks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerstorage.kotlin.outputs.DiskResponse.Companion.toKotlin(args0)
                })
            }),
            encryption = javaType.encryption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerstorage.kotlin.outputs.EncryptionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            resourceGroup = javaType.resourceGroup(),
            skuName = javaType.skuName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
