@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerstorage.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Model for disk for that pool is using
 * @property id ID is the disk identifier visible to the OS. It is typically the WWN or disk ID in formats such as eui.e8238fa6bf530001001b448b45263379 or 0x5002cf6cbc5dd460
 * @property reference Reference is the location of the disk in an external system.
 */
public data class DiskResponse(
    public val id: String,
    public val reference: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerstorage.outputs.DiskResponse): DiskResponse = DiskResponse(
            id = javaType.id(),
            reference = javaType.reference(),
        )
    }
}
