@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerstorage.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Encryption key properties for the pool.
 * @property identity The managed service identities assigned to this resource.
 * @property keyName The name of the key vault key.
 * @property keyVaultUri The URI of the key vault.
 */
public data class EncryptionResponse(
    public val identity: ManagedServiceIdentityResponse? = null,
    public val keyName: String,
    public val keyVaultUri: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerstorage.outputs.EncryptionResponse): EncryptionResponse = EncryptionResponse(
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerstorage.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            keyName = javaType.keyName(),
            keyVaultUri = javaType.keyVaultUri(),
        )
    }
}
