@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerstorage.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Pool resource
 * @property assignments List of resources that should have access to the pool. Typically ARM references to AKS clusters or ACI Container Groups. For local and standard this must be a single reference. For ElasticSAN there can be many.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property poolType Type of the Pool: ephemeralDisk, azureDisk, or elasticsan.
 * @property provisioningState The status of the last operation.
 * @property reclaimPolicy ReclaimPolicy defines what happens to the backend storage when StoragePool is deleted
 * @property resources Resources represent the resources the pool should have.
 * @property status The operational status of the resource
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property zones List of availability zones that resources can be created in.
 */
public data class GetPoolResult(
    public val assignments: List<AssignmentResponse>? = null,
    public val id: String,
    public val location: String,
    public val name: String,
    public val poolType: PoolTypeResponse,
    public val provisioningState: String,
    public val reclaimPolicy: String? = null,
    public val resources: ResourcesResponse? = null,
    public val status: ResourceOperationalStatusResponse,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val zones: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerstorage.outputs.GetPoolResult): GetPoolResult = GetPoolResult(
            assignments = javaType.assignments().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerstorage.kotlin.outputs.AssignmentResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            poolType = javaType.poolType().let({ args0 ->
                com.pulumi.azurenative.containerstorage.kotlin.outputs.PoolTypeResponse.Companion.toKotlin(args0)
            }),
            provisioningState = javaType.provisioningState(),
            reclaimPolicy = javaType.reclaimPolicy().map({ args0 -> args0 }).orElse(null),
            resources = javaType.resources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerstorage.kotlin.outputs.ResourcesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            status = javaType.status().let({ args0 ->
                com.pulumi.azurenative.containerstorage.kotlin.outputs.ResourceOperationalStatusResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.containerstorage.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            zones = javaType.zones().map({ args0 -> args0 }),
        )
    }
}
