@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerstorage.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Concrete proxy resource types can be created by aliasing this type using a specific property type.
 * @property capacityGiB Requested capacity in GiB
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property labels String KV pairs indicating labels
 * @property name The name of the resource
 * @property provisioningState The status of the last operation.
 * @property status The status of the resource.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property volumeType Properties of the volume
 */
public data class GetVolumeResult(
    public val capacityGiB: Double,
    public val id: String,
    public val labels: Map<String, String>,
    public val name: String,
    public val provisioningState: String,
    public val status: ResourceOperationalStatusResponse,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val volumeType: VolumeTypeResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerstorage.outputs.GetVolumeResult): GetVolumeResult = GetVolumeResult(
            capacityGiB = javaType.capacityGiB(),
            id = javaType.id(),
            labels = javaType.labels().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            status = javaType.status().let({ args0 ->
                com.pulumi.azurenative.containerstorage.kotlin.outputs.ResourceOperationalStatusResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.containerstorage.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            volumeType = javaType.volumeType().let({ args0 ->
                com.pulumi.azurenative.containerstorage.kotlin.outputs.VolumeTypeResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
