@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerstorage.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Status of the resource
 * @property message Reason for state.
 * @property state state of the resource
 */
public data class ResourceOperationalStatusResponse(
    public val message: String? = null,
    public val state: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerstorage.outputs.ResourceOperationalStatusResponse): ResourceOperationalStatusResponse = ResourceOperationalStatusResponse(
            message = javaType.message().map({ args0 -> args0 }).orElse(null),
            state = javaType.state(),
        )
    }
}
