@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin

import com.pulumi.azurenative.costmanagement.CloudConnectorArgs.builder
import com.pulumi.azurenative.costmanagement.kotlin.enums.ConnectorBillingModel
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Connector model definition
 * Azure REST API version: 2019-03-01-preview. Prior API version in Azure Native 1.x: 2019-03-01-preview.
 * ## Example Usage
 * ### CloudConnector_Put
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cloudConnector = new AzureNative.CostManagement.CloudConnector("cloudConnector", new()
 *     {
 *         ConnectorName = "aws-123456789012",
 *         CredentialsKey = "arn:aws:iam::123456789012:role/AzureCostManagementRole",
 *         CredentialsSecret = "external-id",
 *         DisplayName = "AWS-Consolidated-1",
 *         ReportId = "HourlyWithResources",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/costmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := costmanagement.NewCloudConnector(ctx, "cloudConnector", &costmanagement.CloudConnectorArgs{
 * 			ConnectorName:     pulumi.String("aws-123456789012"),
 * 			CredentialsKey:    pulumi.String("arn:aws:iam::123456789012:role/AzureCostManagementRole"),
 * 			CredentialsSecret: pulumi.String("external-id"),
 * 			DisplayName:       pulumi.String("AWS-Consolidated-1"),
 * 			ReportId:          pulumi.String("HourlyWithResources"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.costmanagement.CloudConnector;
 * import com.pulumi.azurenative.costmanagement.CloudConnectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cloudConnector = new CloudConnector("cloudConnector", CloudConnectorArgs.builder()
 *             .connectorName("aws-123456789012")
 *             .credentialsKey("arn:aws:iam::123456789012:role/AzureCostManagementRole")
 *             .credentialsSecret("external-id")
 *             .displayName("AWS-Consolidated-1")
 *             .reportId("HourlyWithResources")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:costmanagement:CloudConnector aws-123456789012 /providers/Microsoft.CostManagement/cloudConnectors/{connectorName}
 * ```
 * @property billingModel Connector billing model
 * @property connectorName Connector Name.
 * @property credentialsKey Credentials authentication key (eg AWS ARN)
 * @property credentialsSecret Credentials secret (eg AWS ExternalId)
 * @property defaultManagementGroupId Default ManagementGroupId
 * @property displayName Connector DisplayName
 * @property kind Connector kind (eg aws)
 * @property reportId Identifying source report. (For AWS this is a CUR report name, defined with Daily and with Resources)
 * @property subscriptionId Billing SubscriptionId
 */
public data class CloudConnectorArgs(
    public val billingModel: Output<Either<String, ConnectorBillingModel>>? = null,
    public val connectorName: Output<String>? = null,
    public val credentialsKey: Output<String>? = null,
    public val credentialsSecret: Output<String>? = null,
    public val defaultManagementGroupId: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val reportId: Output<String>? = null,
    public val subscriptionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.CloudConnectorArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.CloudConnectorArgs =
        com.pulumi.azurenative.costmanagement.CloudConnectorArgs.builder()
            .billingModel(
                billingModel?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .connectorName(connectorName?.applyValue({ args0 -> args0 }))
            .credentialsKey(credentialsKey?.applyValue({ args0 -> args0 }))
            .credentialsSecret(credentialsSecret?.applyValue({ args0 -> args0 }))
            .defaultManagementGroupId(defaultManagementGroupId?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .reportId(reportId?.applyValue({ args0 -> args0 }))
            .subscriptionId(subscriptionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CloudConnectorArgs].
 */
@PulumiTagMarker
public class CloudConnectorArgsBuilder internal constructor() {
    private var billingModel: Output<Either<String, ConnectorBillingModel>>? = null

    private var connectorName: Output<String>? = null

    private var credentialsKey: Output<String>? = null

    private var credentialsSecret: Output<String>? = null

    private var defaultManagementGroupId: Output<String>? = null

    private var displayName: Output<String>? = null

    private var kind: Output<String>? = null

    private var reportId: Output<String>? = null

    private var subscriptionId: Output<String>? = null

    /**
     * @param value Connector billing model
     */
    @JvmName("ywvlkofldpumbxcl")
    public suspend fun billingModel(`value`: Output<Either<String, ConnectorBillingModel>>) {
        this.billingModel = value
    }

    /**
     * @param value Connector Name.
     */
    @JvmName("hlipwuqyjjkctldf")
    public suspend fun connectorName(`value`: Output<String>) {
        this.connectorName = value
    }

    /**
     * @param value Credentials authentication key (eg AWS ARN)
     */
    @JvmName("htshtrroohsaqcht")
    public suspend fun credentialsKey(`value`: Output<String>) {
        this.credentialsKey = value
    }

    /**
     * @param value Credentials secret (eg AWS ExternalId)
     */
    @JvmName("cjrdeqpqprujufhe")
    public suspend fun credentialsSecret(`value`: Output<String>) {
        this.credentialsSecret = value
    }

    /**
     * @param value Default ManagementGroupId
     */
    @JvmName("xqqlqeniclbascln")
    public suspend fun defaultManagementGroupId(`value`: Output<String>) {
        this.defaultManagementGroupId = value
    }

    /**
     * @param value Connector DisplayName
     */
    @JvmName("gtmkxqsxxnibyife")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Connector kind (eg aws)
     */
    @JvmName("prlgsmclfgbhthil")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Identifying source report. (For AWS this is a CUR report name, defined with Daily and with Resources)
     */
    @JvmName("huxffsxnlowcufhy")
    public suspend fun reportId(`value`: Output<String>) {
        this.reportId = value
    }

    /**
     * @param value Billing SubscriptionId
     */
    @JvmName("pvekuhipvqfprrvo")
    public suspend fun subscriptionId(`value`: Output<String>) {
        this.subscriptionId = value
    }

    /**
     * @param value Connector billing model
     */
    @JvmName("wfmxmbmxbtyfqlyp")
    public suspend fun billingModel(`value`: Either<String, ConnectorBillingModel>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.billingModel = mapped
    }

    /**
     * @param value Connector billing model
     */
    @JvmName("kxbkdttijhmttewh")
    public fun billingModel(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ConnectorBillingModel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.billingModel = mapped
    }

    /**
     * @param value Connector billing model
     */
    @JvmName("covxfdidyrsdevrp")
    public fun billingModel(`value`: ConnectorBillingModel) {
        val toBeMapped = Either.ofRight<String, ConnectorBillingModel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.billingModel = mapped
    }

    /**
     * @param value Connector Name.
     */
    @JvmName("nadcpcreukiupflq")
    public suspend fun connectorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectorName = mapped
    }

    /**
     * @param value Credentials authentication key (eg AWS ARN)
     */
    @JvmName("banigjcbhlmbuhui")
    public suspend fun credentialsKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentialsKey = mapped
    }

    /**
     * @param value Credentials secret (eg AWS ExternalId)
     */
    @JvmName("cswdifbnipyeheff")
    public suspend fun credentialsSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentialsSecret = mapped
    }

    /**
     * @param value Default ManagementGroupId
     */
    @JvmName("xljxmuveecejkbys")
    public suspend fun defaultManagementGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultManagementGroupId = mapped
    }

    /**
     * @param value Connector DisplayName
     */
    @JvmName("hjgkcmdbnikegdqj")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Connector kind (eg aws)
     */
    @JvmName("nkabpkmuxdwcwqxk")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Identifying source report. (For AWS this is a CUR report name, defined with Daily and with Resources)
     */
    @JvmName("tmurvnimqwqclkfl")
    public suspend fun reportId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reportId = mapped
    }

    /**
     * @param value Billing SubscriptionId
     */
    @JvmName("dqqfuxfbwwrkmkdg")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionId = mapped
    }

    internal fun build(): CloudConnectorArgs = CloudConnectorArgs(
        billingModel = billingModel,
        connectorName = connectorName,
        credentialsKey = credentialsKey,
        credentialsSecret = credentialsSecret,
        defaultManagementGroupId = defaultManagementGroupId,
        displayName = displayName,
        kind = kind,
        reportId = reportId,
        subscriptionId = subscriptionId,
    )
}
